/* Vêtement à persistance de vision:
Version française de  Persistence of vision hoodies
*/
 
/*Persisiene of Vision Hoodies
 by Becky Stewart
 for Adventures in Arduino, Wiley (2015)
 
 Hardware:
 * 7 Lilypad LEDs

Copyright 2015 Becky Stewart

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.  
 */




#include "alphabet.h"


int LEDeteintes = 9; // temps d'extinction des LED entre deux lettres
int LEDalumees = 3; // temps d'allumage des LED

int brochesLED[] = {
  2, 3, 9, 10, 11, A2, A3};


//---------------------------------------------
// setup
// exécution une seule fois après mise spus tension ou remise à zéro (reset)
//---------------------------------------------
void setup()
{
  // définition du mode des broches à OUTPUT
  int i;
  for(int i=0; i<nombreLED; i++) {
    pinMode( brochesLED[i], OUTPUT); 
  }

  Serial.begin(9600);
}

//---------------------------------------------
// loop
// éxécution continuelle après l'initialisation setup()
//---------------------------------------------
void loop()
{
  String message = "HELLO    "; // indique ici ton message en MAJUSCULES
  afficheTexte(message);
}

//---------------------------------------------
// afficheLettre()
// affichage des lettres par les LED
//---------------------------------------------
void afficheLettre(int lettre[nombreTrames][nombreLED])
{
  int trame;
  int led;

  // affichage de la lettre
  for( trame=0; trame<nombreTrames; trame++ ) {
    for( led=0; led<nombreLED; led++ ) {
      digitalWrite( brochesLED[led], lettre[trame][led] );
      Serial.print(lettre[trame][led]);
    } 
    Serial.println();
    // délai entre l'affichage de chaque colonne
    delay(LEDalumees);
  }
  Serial.println("-------");

  // afficher un espace après chaque lettre
  for( led=0; led<nombreLED; led++ ) {
    digitalWrite( brochesLED[led], 0 );
  } 
  // délai pour l'espace entre lettres
  delay(LEDeteintes);
}

//---------------------------------------------
// affichageTexte()
// recoit un message et le sépare en lettres 
//
//---------------------------------------------
void afficheTexte(String texte)
{
  // parcours du message lettre par lettre
  for (int i=0; i<texte.length(); i++)
  {
    switch(texte[i])
    {
    case 'A':
      afficheLettre(A);
      break;
    case 'B':
      afficheLettre(B);
      break;
    case 'C':
      afficheLettre(C);
      break;
    case 'D':
      afficheLettre(D);
      break;
    case 'E':
      afficheLettre(E);
      break;
    case 'F':
      afficheLettre(F);
      break;
    case 'G':
      afficheLettre(G);
      break;
    case 'H':
      afficheLettre(H);
      break;
    case 'I':
      afficheLettre(I);
      break;
    case 'J':
      afficheLettre(J);
      break;
    case 'K':
      afficheLettre(K);
      break;
    case 'L':
      afficheLettre(L);
      break;
    case 'M':
      afficheLettre(M);
      break;
    case 'N':
      afficheLettre(N);
      break;
    case 'O':
      afficheLettre(O);
      break;
    case 'P':
      afficheLettre(P);
      break;
    case 'Q':
      afficheLettre(Q);
      break;
    case 'R':
      afficheLettre(R);
      break;
    case 'S':
      afficheLettre(S);
      break;
    case 'T':
      afficheLettre(T);
      break;
    case 'U':
      afficheLettre(U);
      break;
    case 'V':
      afficheLettre(V);
      break;
    case 'W':
      afficheLettre(W);
      break;
    case 'X':
      afficheLettre(X);
      break;
    case 'Y':
      afficheLettre(Y);
      break;
    case 'Z':
      afficheLettre(Z);
      break;
    case ' ':
      afficheLettre(_);
      break;
    default:
      break;
    }
  }
}







